function resTable = parseLog(filenameWpath)

% --- Read the files
fid = fopen(filenameWpath,'r');
C = textscan(fid, '%s');
endc = length(C{1});

% --- Read timestamp
index = 1;
for v=1:13:endc
   timestampStr = strrep(strrep(strrep(strrep(strrep(C{1}{v},'\',''),...
                                     '/',''),...
                              ':',''),...
                       '.',''),...
                   '_','');
   timestamp(index,1) = str2double(timestampStr);
   index = index + 1;
end

% --- Read positions
% - Read posX
index = 1;
for v=2:13:endc
   posX(index,1) = str2double(C{1}{v});
   index = index + 1;
end
% - Read posY
index = 1;
for v=3:13:endc
   posY(index,1) = str2double(C{1}{v});
   index = index + 1;
end
% - Read posZ
index = 1;
for v=4:13:endc
   posZ(index,1) = str2double(C{1}{v});
   index = index + 1;
end

% --- Read rotations
% - Read rotX
index = 1;
for v=5:13:endc
   rotX(index,1) = str2double(C{1}{v});
   index = index + 1;
end
% - Read rotY
index = 1;
for v=6:13:endc
   rotY(index,1) = str2double(C{1}{v});
   index = index + 1;
end
% - Read rotZ
index = 1;
for v=7:13:endc
   rotZ(index,1) = str2double(C{1}{v});
   index = index + 1;
end

% --- Read marker position
% - Read posPX
index = 1;
for v=8:13:endc
   posPX(index,1) = str2double(C{1}{v});
   index = index + 1;
end
% - Read posPY
index = 1;
for v=9:13:endc
   posPY(index,1) = str2double(C{1}{v});
   index = index + 1;
end
% - Read posPZ
index = 1;
for v=10:13:endc
   posPZ(index,1) = str2double(C{1}{v});
   index = index + 1;
end

% --- Get object rotations
% - Read objRotX
index = 1;
for v=11:13:endc
   objRotX(index,1) = str2double(C{1}{v});
   index = index + 1;
end
% - Read objRotY
index = 1;
for v=12:13:endc
   objRotY(index,1) = str2double(C{1}{v});
   index = index + 1;
end
% - Read objRotZ
index = 1;
for v=13:13:endc
   objRotZ(index,1) = str2double(C{1}{v});
   index = index + 1;
end

% --- Save the results to resTable
resTable = table(timestamp, posX, posY, posZ, rotX, rotY, rotZ, ...
                          posPX, posPY, posPZ, objRotX, objRotY, objRotZ);
end