function [resObj, resDev, resDevRot]=...
        processVVARlog_QoMEX(txtNameWPath, drawFigure, debugFlag, pauseDur)
 
% Init
if ~exist('drawFigure','var')
    drawFigure = false;
end
if ~exist('debugFlag','var')
    debugFlag = false;
end
if ~exist('pauseDur','var')
    animateFlag = false;
    %pauseDur = 0.01;
else
    animateFlag = true;
end
                               
% Read and parse the log file
resTable = parseLog(txtNameWPath);

% Temp colorspace assignment
set(0,'DefaultAxesColorOrder',summer(9))

% Init normal vectors
N = 10;
normalDevOrig = [0 0 0; 0 0 1; 0 0 0; 0 3 0; 0 0 0; 6 0 0]; % plus Z axis
normalObjOrig = [0 0 0; 0 0 1; 0 0 0; 0 3 0; 0 0 0; 6 0 0]; % plus Z axis
markerOrigin = [0 1 -3.24]; 
normF = 1.3; % normalizingFactor

% Plot, if requested
if drawFigure, 
    figure
end

% Get main directions
normObjArrowX_pluX = [0 0 0; 5 0 0]/N; % plus X axis
normObjArrowZ_pluY = [0 0 0; 0 0 1]/N; % plus Z axis
normObjArrowY_minZ = [0 0 0; 0 2 0]/N; % plus Y axis
normObjArrowDirect = cat(1, normObjArrowZ_pluY, normObjArrowY_minZ, normObjArrowX_pluX);

% Find the initial direction that VV is looking
normObjArrowInit = rotateAroundAxis(normalObjOrig./N, ...
                    resTable.objRotX(1), ... % Euler angle X
                    resTable.objRotY(1), ... % Euler angle Y
                    resTable.objRotZ(1));    % Euler angle Z
                
% Get the values
for ind = 2:length(resTable.posPX)  

    % ---- Rotate the object normal
    normObjArrow = rotateAroundAxis(normalObjOrig./N, ...
                    resTable.objRotX(ind), ... % Euler angle X
                    resTable.objRotY(ind), ... % Euler angle Y
                    resTable.objRotZ(ind));    % Euler angle Z
	posnObjArrow = repmat(markerOrigin, size(normalObjOrig,1),1); %Offset
    posnAndNormObjArrow = normObjArrow + posnObjArrow;
    
    % ---- Find rotation matrix to compensate for rotation
    R_seq = vrrotvec(normObjArrow(2,:), normObjArrowInit(2,:));
    R1 = vrrotvec(normObjArrow(2,:), ...    % RM_eu * [0 0 1] +Z axis
                  normObjArrowDirect(4,:)); % [0 1 0] +Y axis
    RM1 = vrrotvec2mat(R1);
    normObjArrMid = normObjArrow*RM1';
    R2 = vrrotvec(normObjArrMid(6,:), ...   % RM_1 * RM_eu * [1 0 0] +X axis
                  normObjArrowDirect(6,:)); % [1 0 0] +X axis
    RM2 = vrrotvec2mat(R2);
    % Rotate
    normObjArrowPlot = (normObjArrow*RM1')*RM2';
    
    
	% Plot the object normal at origin
    if drawFigure, 
        if debugFlag
            subplot(1,2,1)
        end
        plot3(normObjArrow(:,1),...
              normObjArrow(:,2),...
              normObjArrow(:,3), 'b'); hold on;
        axis equal;
        if debugFlag
            subplot(1,2,2)
            plot3(normObjArrowPlot(:,1),...
                  normObjArrowPlot(:,2),...
                  normObjArrowPlot(:,3), 'b'); hold on;
            axis equal;
            if animateFlag
                pause(pauseDur)
            end
        end
    end
    
    % Store values
    resObj(ind-1).rotationAngles = R_seq(end);
    resObj(ind-1).normVec = normObjArrow(2,:)./sqrt(normObjArrow(2,1)^2+...
                                                    normObjArrow(2,2)^2+...
                                                    normObjArrow(2,3)^2);
	resObj(ind-1).normVecUpdated = ...
                normObjArrowPlot(2,:)./sqrt(normObjArrowPlot(2,1)^2+...
                                            normObjArrowPlot(2,2)^2+...
                                            normObjArrowPlot(2,3)^2);
    
    
    % Rotate the device normal
    normDevArrow = rotateAroundAxis(normalDevOrig./N, ...
                    resTable.rotX(ind),... % Euler angle X
                    resTable.rotY(ind),... % Euler angle Y
                    resTable.rotZ(ind));   % Euler angle Z
    % Add device position
    posnDevArrow = repmat([resTable.posPX(ind) ... % position X
                           resTable.posPY(ind) ... % position Y
                           resTable.posPZ(ind)],...% position Z
                          size(normDevArrow,1), 1);% repmat to same size
	posnDevArrowN = posnDevArrow - repmat(markerOrigin, size(posnDevArrow,1), 1);

    % Add position
    posnAndNormDevArrow = normDevArrow + posnDevArrow./normF;
    posnAndNormDevArrowN = normDevArrow + posnDevArrowN./normF;
    
    % Store values
    resDev(ind-1).uvw = normDevArrow(2,:)./sqrt(normDevArrow(2,1)^2 + ...
                                                normDevArrow(2,2)^2 + ...
                                                normDevArrow(2,3)^2);
    resDev(ind-1).u = normDevArrow(2,1);
    resDev(ind-1).v = normDevArrow(2,2);
    resDev(ind-1).w = normDevArrow(2,3);
    resDev(ind-1).normDevArrow = normDevArrow;
    resDev(ind-1).xyz = posnDevArrowN(2,:)./normF;
    resDev(ind-1).x = posnDevArrowN(2,1)./normF;
    resDev(ind-1).y = posnDevArrowN(2,2)./normF;
    resDev(ind-1).z = posnDevArrowN(2,3)./normF;
    resDev(ind-1).posnDevArrowN = posnDevArrowN./normF;
        
    % ---- Apply rotation matrix RM to the relative position
    posnAndNormDevArrowRot = (posnAndNormDevArrowN*RM1')*RM2';
	
    % Store values
    difVec = posnAndNormDevArrowRot(2,:) - posnAndNormDevArrowRot(1,:);
    resDevRot(ind-1).uvw = difVec./sqrt(difVec(:,1)^2 + ...
                                        difVec(:,2)^2 + ...
                                        difVec(:,3)^2);
	resDevRot(ind-1).u = posnAndNormDevArrowRot(2,1) - ...
                            posnAndNormDevArrowRot(1,1);
	resDevRot(ind-1).v = posnAndNormDevArrowRot(2,2) - ...
                            posnAndNormDevArrowRot(1,2);
	resDevRot(ind-1).w = posnAndNormDevArrowRot(2,3) - ...
                            posnAndNormDevArrowRot(1,3);
    resDevRot(ind-1).xyz = posnAndNormDevArrowRot(1,:);
    resDevRot(ind-1).x = posnAndNormDevArrowRot(1,1);
    resDevRot(ind-1).y = posnAndNormDevArrowRot(1,2);
    resDevRot(ind-1).z = posnAndNormDevArrowRot(1,3);
    resDevRot(ind-1).posnAndNormDevArrowRot = posnAndNormDevArrowRot;
    
    % Plot the device normal at device
    if drawFigure, 
        if debugFlag
            subplot(1,2,1)
        end
        plot3(posnAndNormDevArrowN(:,1), ...
              posnAndNormDevArrowN(:,2), ...
              posnAndNormDevArrowN(:,3), 'r'), hold on;
        %plot3(markerOrigin(:,1), markerOrigin(:,2), markerOrigin(:,3), 'ko');
        plot3(0, 0, 0, 'ks');
        axis equal; 

        % --- plot the one with updated location
        if debugFlag
            subplot(1,2,2)
            %d
            plot3(posnAndNormDevArrowRot(:,1), ...
                  posnAndNormDevArrowRot(:,2), ...
                  posnAndNormDevArrowRot(:,3), 'g'), hold on;
            plot3(0, 0, 0, 'ks');
            axis equal; 
            if animateFlag
                pause(pauseDur)
            end
        end
    end

    
    % --- Store values
    % Device position
    posDevice(ind-1,:) = posnDevArrow(2,:);
    % Position vector between the device and the marker
    posRelDeviceTmp = posnDevArrow(2,:) - markerOrigin;
    posRelDevice(ind-1,:) = posRelDeviceTmp;
    % Normalized position vector between the device and the marker
    posNorDevice(ind-1,:)=posRelDeviceTmp./sqrt(posRelDeviceTmp(1,1)^2+...
                                                posRelDeviceTmp(1,2)^2+...
                                                posRelDeviceTmp(1,3)^2);
    % Normal vector of the device
    norDevice(ind-1,:) = normDevArrow(2,:)*N;
    % Normal vector of the object
    norObject(ind-1,:) = normObjArrow(2,:)*N;
end

% Plot origin as well
if drawFigure, 
    %plot3(markerOrigin(:,1), markerOrigin(:,2), markerOrigin(:,3), 'ko');
    axis equal, xlabel('x'), ylabel('y'), zlabel('z')
end

end
