function pts =  rotateAroundAxis(points, xDeg,yDeg,zDeg)

% Assuming the input array is an n x 3 array
ptsInp = points';

% Use terms instead of x,y,z
yaw   = zDeg;
pitch = yDeg;
roll  = xDeg;

% These are the rotation matrices for yaw, pitch, roll
rmX = [1         0           0; 
       0 cosd(roll) -sind(roll); 
       0 sind(roll)  cosd(roll)];
rmY = [cosd(pitch) 0 sind(pitch); 
                 0 1          0; 
      -sind(pitch) 0 cosd(pitch)];
rmZ = [cosd(yaw) -sind(yaw) 0; 
       sind(yaw)  cosd(yaw) 0; 
              0           0 1];

% As described in the Unity webpage, the rotation is done first on z, then
% x, and lastly on y, on this order.
rmAll = rmY*rmX*rmZ;

% Apply rotation
pts = (rmAll*ptsInp)';

end