% ============ script_analyseVVARresults ===============
% --- clear all & init
close all; clear; clc;
if ~isdir('figures_init'), mkdir('figures_init'); end
if ~isdir('figures'), mkdir('figures'); end

% Find MATLAB version
v = ver('MATLAB'); 

% Init names and participant number
N = 20;
contents = {'Fredrick','Nico'};
resultPath = [pwd filesep 'results' filesep];

% For each participant
participantRange = 1:N;
for indPt = participantRange
    % For each content
    for indCt = 1:length(contents)
        % Find the result files -- format:<Participant_11_Fredrick>
        fileNameWPath = [resultPath 'Participant_' ...
                        num2str(indPt, '%02d') '_' contents{indCt} '.txt'];
        
        % Read and process the log file
        [resObj, resDev, resDevRot] = processVVARlog_QoMEX(fileNameWPath);
        if indCt == 1
            resAll_Fred(indPt).resObj    = resObj;
            resAll_Fred(indPt).resDev    = resDev;
            resAll_Fred(indPt).resDevRot = resDevRot;
        else
            resAll_Nico(indPt).resObj    = resObj;
            resAll_Nico(indPt).resDev    = resDev;
            resAll_Nico(indPt).resDevRot = resDevRot;
        end
        
        
        % -- Analyse
        % ==================================================
        % 1. Find the average and std distance from the marker
        distanceVec = sqrt( ([resDev.x]').^2 + ([resDev.y]').^2 + ([resDev.z]').^2 );
        
        % Compute and store mean and std values
        distResArr{:,indPt,indCt}  = distanceVec;
        distResArrAvg(indPt,indCt) = mean(distanceVec);
        distResArrStd(indPt,indCt) = std(distanceVec);
        distResArrMax(indPt,indCt) = max(distanceVec);
        distResArrMin(indPt,indCt) = min(distanceVec);
      
        
        
        % 2. STD of the dot product of deviceNormal and positionNormal
        for ind = 1:size([resDev.u]',1)
            posVecN = -resDev(ind).xyz./ sqrt((resDev(ind).x).^2+...
                                               (resDev(ind).y).^2+...
                                               (resDev(ind).z).^2);
            dotProduct_normals(ind,1) = dot(resDev(ind).uvw, posVecN);
        end
        deviceRotationArr{:,indPt,indCt}  = dotProduct_normals;
        deviceRotationArrAvg(indPt,indCt) = mean(dotProduct_normals);
        deviceRotationArrStd(indPt,indCt) = std(dotProduct_normals);
        
        
        
        % 3. STD of object rotation
        normVec = reshape([resObj.normVec]',3,[])';
        meanObjNormal = median(normVec,1);
        deviationFromMeanObjNormal = normVec - ...
                repmat(meanObjNormal, size(normVec,1),1);
        for ind = 1:size(normVec,1), 
            dist_devFromMeanObjN(ind,1) = ...
                norm(deviationFromMeanObjNormal(ind,:),2); 
        end
        objectRotationArr{:,indPt,indCt}  = dist_devFromMeanObjN;
        objectRotationArrStd(indPt,indCt) = std(dist_devFromMeanObjN);
        
        
        
        % 4. Plot individual graphs
        normVec = reshape([resObj.normVec]',3,[])';
        quiver3([resDev.x]', [resDev.y]', [resDev.z]', ...
                -[resDev.u]', -[resDev.v]', -[resDev.w]','b');
        hold on; plot3(0,0,0,'ko','MarkerFaceColor','k')
        quiver3(0,0,0,normVec(1,1),normVec(1,2),normVec(1,3),'k')
        xlabel('x'), ylabel('y'), zlabel('z'), axis equal
        title(['Participant-' num2str(indPt,'%02d') ' - ' contents{indCt}]);
        pause(0.1);
        saveas(gcf, ['figures_init/plot3d_participant-' num2str(indPt,'%02d') '_' contents{indCt} '.png']);
        %saveas(gcf, ['figures_init/plot3d_participant-' num2str(indPt,'%02d') '_' contents{indCt} '.fig']);
        close(gcf);
        
        normVecUpdated = reshape([resObj.normVecUpdated]',3,[])';
        quiver3([resDevRot.x]', [resDevRot.y]', [resDevRot.z]', ...
                -[resDevRot.u]', -[resDevRot.v]', -[resDevRot.w]','b');
        hold on; plot3(0,0,0,'ko','MarkerFaceColor','k')
        quiver3(0,0,0,normVecUpdated(1,1),normVecUpdated(1,2),normVecUpdated(1,3),'k')
        xlabel('x'), ylabel('y'), zlabel('z'), axis equal
        title(['Participant-' num2str(indPt,'%02d') ' - ' contents{indCt}]);
        pause(0.1);
        saveas(gcf, ['figures_init/plot3du_participant-' num2str(indPt,'%02d') '_' contents{indCt} '.png']);
        %saveas(gcf, ['figures_init/plot3du_participant-' num2str(indPt,'%02d') '_' contents{indCt} '.fig']);
        close(gcf);
        
        
        
        % 5. Plot physical location of the viewer
        figure, plot( ([resDev.x]'), ([resDev.y]'), 'bo'), hold on;
        plot(0,0,'ko','MarkerFaceColor','k'); hold off;
        grid on;
        xlabel('x'), ylabel('y'), zlabel('z'), axis equal
        title(['Participant-' num2str(indPt,'%02d') ' - ' contents{indCt}]);
        % ADD Quantization and pool
        pause(0.1);
        saveas(gcf, ['figures_init/locPhy_participant-' num2str(indPt,'%02d') '_' contents{indCt} '.png']);
        %saveas(gcf, ['figures_init/locPhy_participant-' num2str(indPt,'%02d') '_' contents{indCt} '.fig']);
        close(gcf);
        
        
                     
        % 6. Plot physical angle of the viewer
        angPhy = atan2d( ([resDev.x]'), ([resDev.y]') );
        figure, hist(angPhy);
        pause(0.1);
        saveas(gcf, ['figures_init/bhstPhy_participant-' num2str(indPt,'%02d') '_' contents{indCt} '.png']);
        %saveas(gcf, ['figures_init/bhstPhy_participant-' num2str(indPt,'%02d') '_' contents{indCt} '.fig']);
        close(gcf);
        
        angPhy(angPhy<0) = angPhy(angPhy<0) + 360;
        angPhyBin = [];
        binDeg = 10;
        for indBin = 1:(360/binDeg)
            Ilow = find(angPhy<binDeg*indBin);
            Ihig = find(angPhy>=binDeg*(indBin-1));
            I = intersect(Ilow, Ihig);
            angPhyBin(indBin) = length(I);
        end
        angPhyPrb = angPhyBin./sum(angPhyBin);
        figure, bar(angPhyPrb)
        xlabel('x'), ylabel('y'), zlabel('z'),
        title(['Participant-' num2str(indPt,'%02d') ' - ' contents{indCt}]);
        if (strcmp(v.Release,'(R2016b)')) || (str2double(v.Release(3:end-2))>2016)
            xticks(1:360/binDeg); xticklabels(binDeg:binDeg:360); xtickangle(45);
        else
            set(gca,'XTick',1:360/binDeg,'XTickLabels',binDeg:binDeg:360,'XTickLabelRotation',45)
        end
        pause(0.1);
        axis([0 360/binDeg -inf inf])
        pause(0.1);
        saveas(gcf, ['figures_init/hstPhy_participant-' num2str(indPt,'%02d') '_' contents{indCt} '.png']);
        %saveas(gcf, ['figures_init/hstPhy_participant-' num2str(indPt,'%02d') '_' contents{indCt} '.fig']);
        close(gcf);
        
        if (strcmp(v.Release,'(R2016b)')) || (str2double(v.Release(3:end-2))>2016)
            edgesVec360 = 0:binDeg:360;
            edgesVecRad = edgesVec360*3.14/180;
            figure, polarhistogram('BinEdges', edgesVecRad, 'BinCounts',angPhyPrb)
            title(['Participant-' num2str(indPt,'%02d') ' - ' contents{indCt}]);
            set(gca, 'ThetaZeroLocation', 'bottom')
            pause(0.1);
            saveas(gcf, ['figures_init/phstPhy_participant-' num2str(indPt,'%02d') '_' contents{indCt} '.png']);
            %saveas(gcf, ['figures_init/phstPhy_participant-' num2str(indPt,'%02d') '_' contents{indCt} '.fig']);
            close(gcf);
        end
        
        angPhyPrbArr{:, indPt, indCt} = angPhyPrb;
        
        
        
        % 7. Plot location of the viewer wrt the VV
        figure, plot( ([resDevRot.x]'), ([resDevRot.y]'), 'bo'), hold on;
        plot(0,0,'ko','MarkerFaceColor','k'); hold off;
        grid on;
        xlabel('x'), ylabel('y'), zlabel('z'), axis equal
        title(['Participant-' num2str(indPt,'%02d') ' - ' contents{indCt}]);
        % ADD Quantization and pool
        pause(0.1);
        saveas(gcf, ['figures_init/locRel_participant-' num2str(indPt,'%02d') '_' contents{indCt} '.png']);
        %saveas(gcf, ['figures_init/locRel_participant-' num2str(indPt,'%02d') '_' contents{indCt} '.fig']);
        close(gcf);
        
        
                     
        % 8. Plot angle of the viewer wrt the VV
        angRel = atan2d( ([resDevRot.x]'), ([resDevRot.y]') );
        figure, hist(angRel);
        pause(0.1);
        saveas(gcf, ['figures_init/bhstRel_participant-' num2str(indPt,'%02d') '_' contents{indCt} '.png']);
        %saveas(gcf, ['figures_init/bhstRel_participant-' num2str(indPt,'%02d') '_' contents{indCt} '.fig']);
        close(gcf);
        
        angRel(angRel<0) = angRel(angRel<0) + 360;
        angRelBin = [];
        binDeg = 10;
        for indBin = 1:(360/binDeg)
            Ilow = find(angRel<binDeg*indBin);
            Ihig = find(angRel>=binDeg*(indBin-1));
            I = intersect(Ilow, Ihig);
            angRelBin(indBin) = length(I);
        end
        angRelPrb = angRelBin./sum(angRelBin);
        figure, bar(angRelPrb)
        if (strcmp(v.Release,'(R2016b)')) || (str2double(v.Release(3:end-2))>2016)
            xticks(1:360/binDeg); xticklabels(binDeg:binDeg:360); xtickangle(45);
        else
            set(gca,'XTick',1:360/binDeg,'XTickLabels',binDeg:binDeg:360,'XTickLabelRotation',45)
        end
        pause(0.1);
        axis([0 360/binDeg -inf inf])
        title(['Participant-' num2str(indPt,'%02d') ' - ' contents{indCt}]);
        pause(0.1);
        saveas(gcf, ['figures_init/hstRel_participant-' num2str(indPt,'%02d') '_' contents{indCt} '.png']);
        %saveas(gcf, ['figures_init/hstRel_participant-' num2str(indPt,'%02d') '_' contents{indCt} '.fig']);
        close(gcf);
        
        if (strcmp(v.Release,'(R2016b)')) || (str2double(v.Release(3:end-2))>2016)
            edgesVec360 = 0:binDeg:360;
            edgesVecRad = edgesVec360*3.14/180;
            figure, polarhistogram('BinEdges', edgesVecRad, 'BinCounts',angRelPrb)
            title(['Participant-' num2str(indPt,'%02d') ' - ' contents{indCt}]);
            set(gca, 'ThetaZeroLocation', 'bottom')
            pause(0.1);
            saveas(gcf, ['figures_init/phstRel_participant-' num2str(indPt,'%02d') '_' contents{indCt} '.png']);
            %saveas(gcf, ['figures_init/phstRel_participant-' num2str(indPt,'%02d') '_' contents{indCt} '.fig']);
            close(gcf);
        end
        
        angRelPrbArr{:, indPt, indCt} = angRelPrb;
        
        
                     
        % 9. Plot the elevation
        xyV = sqrt( ([resDevRot.x]').^2 + ([resDevRot.y]').^2 );
        zV = ([resDevRot.z]');
        distV = sqrt( ([resDev.x]').^2 + ([resDev.y]').^2 + ([resDev.z]').^2 );
        xyResArrMax(indPt, indCt) = max(xyV);
        indInv = zV<0; xyV(indInv) = []; zV(indInv) = []; distV(indInv)=[];
        maxHor = max(xyV); maxVer = max(zV);
        figure, plot(xyV, zV, 'bo'), hold on;
        plot(0,0,'ko','MarkerFaceColor','k'); hold off;
        grid on;
        axis equal, axis([0 maxHor 0 maxVer]);
        angVer = asind(zV./distV);
        angVerBin = [];
        binDeg = 5;
        for indBin = 1:90/binDeg
            Ilow = find(angVer<binDeg*indBin);
            Ihig = find(angVer>=binDeg*(indBin-1));
            I = intersect(Ilow, Ihig);
            angVerBin(indBin) = length(I);
        end
        angVerPrb = angVerBin./sum(angVerBin);
        pause(0.1);
        saveas(gcf, ['figures_init/locVer_participant-' num2str(indPt,'%02d') '_' contents{indCt} '.png']);
        %saveas(gcf, ['figures_init/locVer_participant-' num2str(indPt,'%02d') '_' contents{indCt} '.fig']);
        close(gcf);
        
        figure, bar(angVerPrb)
        if (strcmp(v.Release,'(R2016b)')) || (str2double(v.Release(3:end-2))>2016)
            xticks(1:90/binDeg); xticklabels(binDeg:binDeg:90); xtickangle(45);
        else
            set(gca,'XTick',1:90/binDeg,'XTickLabels',binDeg:binDeg:90,'XTickLabelRotation',45)
        end
        axis([0 18 -inf inf])
        title(['Participant-' num2str(indPt,'%02d') ' - ' contents{indCt}]);
        pause(0.1);
        saveas(gcf, ['figures_init/hstVer_participant-' num2str(indPt,'%02d') '_' contents{indCt} '.png']);
        %saveas(gcf, ['figures_init/hstVer_participant-' num2str(indPt,'%02d') '_' contents{indCt} '.fig']);
        close(gcf);
        
        if (strcmp(v.Release,'(R2016b)')) || (str2double(v.Release(3:end-2))>2016)
            edgesVec360 = 0:binDeg:360;
            edgesVecRad = edgesVec360*3.14/180;
            edgesBinsVer = cat(2, angVerPrb, zeros(size(90+binDeg:binDeg:360)));
            figure, polarhistogram('BinEdges', edgesVecRad, 'BinCounts',edgesBinsVer)
            title(['Participant-' num2str(indPt,'%02d') ' - ' contents{indCt}]);
            set(gca, 'ThetaLim', [0 90])
            set(gca, 'ThetaDir', 'clockwise')
            set(gca, 'ThetaZeroLocation', 'left')
            pause(0.1);
            saveas(gcf, ['figures_init/phstVer_participant-' num2str(indPt,'%02d') '_' contents{indCt} '.png']);
            %saveas(gcf, ['figures_init/phstVer_participant-' num2str(indPt,'%02d') '_' contents{indCt} '.fig']);
            close(gcf);
        end
        
        angVerPrbArr{:, indPt, indCt} = angVerPrb;

    end   
end

save('collectedResults_VVAR_init.mat');

%% ---- Load the saved MAT file
clear; load('collectedResults_VVAR_init.mat');

%% ---- Relative planar polar figure - Fred
indCount = 1;
for indPt = participantRange
    % Create array first
    angRelPrbArr_Fred(indCount, :) = angRelPrbArr{:, indPt, 1};
    indCount = indCount + 1;
end
angRelPrbArr_FredN = sum(angRelPrbArr_Fred,1)./size(angRelPrbArr_Fred,1);

binDeg = 10;
if (strcmp(v.Release,'(R2016b)')) || (str2double(v.Release(3:end-2))>2016)
    edgesVec360 = 0:binDeg:360;
    edgesVecRad = edgesVec360*3.14/180;
    figure, polarhistogram('BinEdges', edgesVecRad, 'BinCounts', angRelPrbArr_FredN)
    %title(['Relative angles - ' contents{1}]);
    set(gca, 'ThetaZeroLocation', 'bottom')
    set(gca,'FontSize',18)
    pause(0.1);
    saveas(gcf, ['figures/phstRel_all_' contents{1} '.png']);
    %saveas(gcf, ['figures_init/phstRel_all_' contents{1} '.fig']);
    close(gcf);
end


%% ---- Relative planar polar figure - Nico
indCount = 1;
for indPt = participantRange
    % Create array first
    angRelPrbArr_Nico(indCount, :) = angRelPrbArr{:, indPt, 2};
    indCount = indCount + 1;
end
angRelPrbArr_NicoN = sum(angRelPrbArr_Nico,1)./size(angRelPrbArr_Nico,1);

binDeg = 10;
if (strcmp(v.Release,'(R2016b)')) || (str2double(v.Release(3:end-2))>2016)
    edgesVec360 = 0:binDeg:360;
    edgesVecRad = edgesVec360*3.14/180;
    figure, polarhistogram('BinEdges', edgesVecRad, 'BinCounts', angRelPrbArr_NicoN)
    %title(['Relative angles - ' contents{2}]);
    set(gcf,'name', ['Relative angles - ' contents{2}]);
    set(gca, 'ThetaZeroLocation', 'bottom')
    set(gca,'FontSize',18)

    pause(0.1);
    saveas(gcf, ['figures/phstRel_all_' contents{2} '.png']);
    %saveas(gcf, ['figures_init/phstRel_all_' contents{2} '.fig']);
    close(gcf);
end

%% ---- Vertical polar figure - Fred
indCount = 1;
for indPt = participantRange
    % Create array first
    angVerPrbArr_Fred(indCount, :) = angVerPrbArr{:, indPt, 1};
    indCount = indCount + 1;
end
angVerPrbArr_FredN = sum(angVerPrbArr_Fred,1)./size(angVerPrbArr_Fred,1);

binDeg = 5;
if (strcmp(v.Release,'(R2016b)')) || (str2double(v.Release(3:end-2))>2016)
    edgesVec360 = 0:binDeg:360;
    edgesVecRad = edgesVec360*3.14/180;
    edgesBinsVer = cat(2, angVerPrbArr_FredN, zeros(size(90+binDeg:binDeg:360)));
    figure, polarhistogram('BinEdges', edgesVecRad, 'BinCounts',edgesBinsVer)
    %title('Vertical angles - Fred');
    set(gcf,'name', 'Vertical angles - Fred');
    set(gca, 'ThetaLim', [0 90])
    set(gca, 'ThetaDir', 'clockwise')
    set(gca, 'ThetaZeroLocation', 'left')
    set(gca,'FontSize',18)

    pause(0.1);
    saveas(gcf, ['figures/phstVer_all_' contents{1} '.png']);
    %saveas(gcf, ['figures_init/phstVer_all_' contents{1} '.fig']);
    close(gcf);
end

%% ---- Vertical polar figure - Nico
indCount = 1;
for indPt = participantRange
    % Create array first
    angVerPrbArr_Nico(indCount, :) = angVerPrbArr{:, indPt, 2};
    indCount = indCount + 1;
end
angVerPrbArr_NicoN = sum(angVerPrbArr_Nico,1)./size(angVerPrbArr_Nico,1);

binDeg = 5;
if (strcmp(v.Release,'(R2016b)')) || (str2double(v.Release(3:end-2))>2016)
    edgesVec360 = 0:binDeg:360;
    edgesVecRad = edgesVec360*3.14/180;
    edgesBinsVer = cat(2, angVerPrbArr_NicoN, zeros(size(90+binDeg:binDeg:360)));
    figure, polarhistogram('BinEdges', edgesVecRad, 'BinCounts',edgesBinsVer)
    %title('Vertical angles - Nico');
    set(gcf,'name', 'Vertical angles - Nico');
    set(gca, 'ThetaLim', [0 90])
    set(gca, 'ThetaDir', 'clockwise')
    set(gca, 'ThetaZeroLocation', 'left')
    set(gca,'FontSize',18)

    pause(0.1);
    saveas(gcf, ['figures/phstVer_all_' contents{2} '.png']);
    %saveas(gcf, ['figures_init/phstVer_all_' contents{2} '.fig']);
    close(gcf);
end



%% ---- Draw users' physical location - Fred
limLength = 4;
edgLength = 0.2;
N1 = 2*limLength/edgLength;

clear locMapArr locMapArrN minMaxArr;

indCount = 1;
for indPts = participantRange
    clear xVecF_temp yVecF_temp;
    xVecF_temp = [resAll_Fred(indPts).resDev.x]';
    yVecF_temp = [resAll_Fred(indPts).resDev.y]';
    minMaxArr(indCount,:) = [min(xVecF_temp) max(xVecF_temp) min(yVecF_temp) max(yVecF_temp)];
    for indX = 1:N1
        for indY = 1:N1
            elemsXpos = find(xVecF_temp > -limLength + edgLength*(indX-1));
            elemsXneg = find(xVecF_temp < -limLength + edgLength*indX );
            elemsYpos = find(yVecF_temp < limLength - edgLength*(indY-1));
            elemsYneg = find(yVecF_temp > limLength - edgLength*indY );
            
            xIntersect = intersect(elemsXneg, elemsXpos);
            yIntersect = intersect(elemsYneg, elemsYpos);
            locMapArr(indY, indX, indCount) = length(intersect(xIntersect, yIntersect));
        end
    end
    indCount = indCount + 1;
end
for indC = 1:size(locMapArr,3)
    locMapArrN(:,:,indC) = locMapArr(:,:,indC)./sum(sum(locMapArr(:,:,indC)));
    disp(['sum is: ' num2str(sum(sum(locMapArr(:,:,indC))))]);
end
aggPhyDistMap = sum(locMapArrN, 3)./size(locMapArrN,3);
aggPhyDistMap(N1/2:N1/2+1,N1/2:N1/2+1) = -max(aggPhyDistMap(:))/10;
figure, imagesc(aggPhyDistMap), axis image

%% ---- Draw users' physical location - Nico
limLength = 4;
edgLength = 0.2;
N1 = 2*limLength/edgLength;

clear locMapArr locMapArrN minMaxArr;

indCount = 1;
for indPts = participantRange
    clear xVecF_temp yVecF_temp;
    xVecF_temp = [resAll_Nico(indPts).resDev.x]';
    yVecF_temp = [resAll_Nico(indPts).resDev.y]';
    minMaxArr(indCount,:) = [min(xVecF_temp) max(xVecF_temp) min(yVecF_temp) max(yVecF_temp)];
    for indX = 1:N1
        for indY = 1:N1
            elemsXpos = find(xVecF_temp > -limLength + edgLength*(indX-1));
            elemsXneg = find(xVecF_temp < -limLength + edgLength*indX );
            elemsYpos = find(yVecF_temp < limLength - edgLength*(indY-1));
            elemsYneg = find(yVecF_temp > limLength - edgLength*indY );
            
            xIntersect = intersect(elemsXneg, elemsXpos);
            yIntersect = intersect(elemsYneg, elemsYpos);
            locMapArr(indY, indX, indCount) = length(intersect(xIntersect, yIntersect));
        end
    end
    indCount = indCount + 1;
end
for indC = 1:size(locMapArr,3)
    locMapArrN(:,:,indC) = locMapArr(:,:,indC)./sum(sum(locMapArr(:,:,indC)));
    disp(['sum is: ' num2str(sum(sum(locMapArr(:,:,indC))))]);
end
aggPhyDistMap = sum(locMapArrN, 3)./size(locMapArrN,3);
aggPhyDistMap(N1/2:N1/2+1,N1/2:N1/2+1) = -max(aggPhyDistMap(:))/10;
figure, imagesc(aggPhyDistMap), axis image

%% ---- Draw users' relative location - Fred
limLength = 4;
edgLength = 0.2;
N1 = 2*limLength/edgLength;

clear locMapArr locMapArrN minMaxArr;

indCount = 1;
for indPts = participantRange
    clear xVecF_temp yVecF_temp;
    xVecF_temp = [resAll_Fred(indPts).resDevRot.x]';
    yVecF_temp = [resAll_Fred(indPts).resDevRot.y]';
    minMaxArr(indCount,:) = [min(xVecF_temp) max(xVecF_temp) min(yVecF_temp) max(yVecF_temp)];
    for indX = 1:N1
        for indY = 1:N1
            elemsXpos = find(xVecF_temp < limLength - edgLength*(indX-1));
            elemsXneg = find(xVecF_temp > limLength - edgLength*indX );
            elemsYpos = find(yVecF_temp > -limLength + edgLength*(indY-1));
            elemsYneg = find(yVecF_temp < -limLength + edgLength*indY );
            
            xIntersect = intersect(elemsXneg, elemsXpos);
            yIntersect = intersect(elemsYneg, elemsYpos);
            locMapArr(indY, indX, indCount) = length(intersect(xIntersect, yIntersect));
        end
    end
    indCount = indCount + 1;
end
for indC = 1:size(locMapArr,3)
    locMapArrN(:,:,indC) = locMapArr(:,:,indC)./sum(sum(locMapArr(:,:,indC)));
    disp(['sum is: ' num2str(sum(sum(locMapArr(:,:,indC))))]);
end
aggRelDistMap = sum(locMapArrN, 3)./size(locMapArrN,3);
aggRelDistMap(N1/2:N1/2+1,N1/2:N1/2+1) = -max(aggRelDistMap(:))/10;
figure, imagesc(aggRelDistMap), axis image


%% ---- Draw users' relative location - Nico
limLength = 4;
edgLength = 0.2;
N1 = 2*limLength/edgLength;

clear locMapArr locMapArrN minMaxArr;

indCount = 1;
for indPts = participantRange
    clear xVecF_temp yVecF_temp;
    xVecF_temp = [resAll_Nico(indPts).resDevRot.x]';
    yVecF_temp = [resAll_Nico(indPts).resDevRot.y]';
    minMaxArr(indCount,:) = [min(xVecF_temp) max(xVecF_temp) min(yVecF_temp) max(yVecF_temp)];
    for indX = 1:N1
        for indY = 1:N1
            elemsXpos = find(xVecF_temp < limLength - edgLength*(indX-1));
            elemsXneg = find(xVecF_temp > limLength - edgLength*indX );
            elemsYpos = find(yVecF_temp > -limLength + edgLength*(indY-1));
            elemsYneg = find(yVecF_temp < -limLength + edgLength*indY );
            
            xIntersect = intersect(elemsXneg, elemsXpos);
            yIntersect = intersect(elemsYneg, elemsYpos);
            locMapArr(indY, indX, indCount) = length(intersect(xIntersect, yIntersect));
        end
    end
    indCount = indCount + 1;
end
for indC = 1:size(locMapArr,3)
    locMapArrN(:,:,indC) = locMapArr(:,:,indC)./sum(sum(locMapArr(:,:,indC)));
    disp(['sum is: ' num2str(sum(sum(locMapArr(:,:,indC))))]);
end
aggRelDistMap = sum(locMapArrN, 3)./size(locMapArrN,3);
aggRelDistMap(N1/2:N1/2+1,N1/2:N1/2+1) = -max(aggRelDistMap(:))/10;
figure, imagesc(aggRelDistMap), axis image

% ======== EoF ========